﻿
// -------------------------------------------------------- //
// ---------------------  Star Rating --------------------- //
// -------------------------------------------------------- //

(function ($) {

    $.widget("voxco.starRating", {

        options: {
            numStars: undefined,
            numParts: undefined,
            disabled: false
        },

        _validateNumStars: function (value) {
            var parsedValue = parseInt(value, 10);
            return (!parsedValue || isNaN(parsedValue)) ? 5 : parsedValue;
        },

        _validateStarParts: function (value) {
            var parsedValue = parseInt(value, 10);
            return (!parsedValue || isNaN(parsedValue)) ? 1 : parsedValue;
        },

        _create: function () {
            var starRating = this;

            starRating.options.numStars = this._validateNumStars(starRating.options.numStars || $(this.element).attr('data-num-stars'));
            starRating.options.numParts = this._validateStarParts(starRating.options.numParts || $(this.element).attr('data-num-star-parts'));

            // Create elements
            var stars = _.flatten(_.map(_.range(0, starRating.options.numStars), function (starNumber) {
                return _.map(_.range(0, starRating.options.numParts), function (starPart) {
                    return $('<div>').addClass('star off').attr('value', (starNumber + (starPart + 1.0) / starRating.options.numParts).toFixed(3)).append($('<a>')).get(0);
                });
            }));

            var clearRating = $('<div>').addClass('clearRating off');

            // Replace existing elements in DOM
            $('.star,.clearRating', this.element).remove();
            $(this.element).append(clearRating)
               .append(stars)
               .addClass('ui-helper-clearfix');

            this.refreshLayout();
            this.refresh();
            this._bindEvents();
        },

        _addClassToStars: function (cls, value) {
            var currentValue = parseFloat(value);
            if (isNaN(currentValue)) { currentValue = 0; }

            $.each($('.star', this.element), function () {
                if (parseFloat($(this).attr('value')) <= currentValue) {
                    $(this).removeClass('off').addClass(cls);
                } else {
                    $(this).addClass('off');
                }
            });
        },

        _clearHandler: function (args) { args.data.starRating.clearRating(); },
        _simpleMouseEnterHandler: function () { $(this).removeClass('off').addClass('hover'); },
        _simpleMouseLeaveHandler: function () { $(this).addClass('off').removeClass('hover'); },
        _starMouseEnterHandler: function (args) {
            $('.star', args.data.starRating.element).removeClass('off on hover');
            args.data.starRating._addClassToStars('hover', $(this).attr('value'));
        },
        _starMouseLeaveHandler: function (args) { args.data.starRating.refresh(); },
        _starClickHandler: function (args) { args.data.starRating.setRating(parseFloat($(this).attr('value'))); },

        _bindEvents: function () {

            $('.clearRating', this.element).unbind('click', this._clearHandler)
                               .unbind('mouseenter', this._simpleMouseEnterHandler)
                               .unbind('mouseleave', this._simpleMouseLeaveHandler);
            $('.star', this.element).unbind('click', this._starClickHandler)
                        .unbind('mouseenter', this._starMouseEnterHandler)
                        .unbind('mouseleave', this._starMouseLeaveHandler);

            if (!this.options.disabled) {
                $('.clearRating', this.element).bind('click', { starRating: this }, this._clearHandler)
                                       .bind('mouseenter', { starRating: this }, this._simpleMouseEnterHandler)
                                       .bind('mouseleave', { starRating: this }, this._simpleMouseLeaveHandler);
                $('.star', this.element).bind('click', { starRating: this }, this._starClickHandler)
                                .bind('mouseenter', { starRating: this }, this._starMouseEnterHandler)
                                .bind('mouseleave', { starRating: this }, this._starMouseLeaveHandler);
            }
        },

        _setOption: function (key, value) {
            var recreate = false;

            if (key === 'numStars') { arguments[1] = this._validateNumStars(value); }
            if (key === 'numParts') { arguments[1] = this._validateStarParts(value); }

            $.Widget.prototype._setOption.apply(this, arguments);

            if (key === 'numStars' || key === 'numParts') {
                this._create();
            }

            if (key === 'disabled') {
                this._bindEvents();
                this.refresh();
            }
        },

        refresh: function () {
            $('.star', this.element).removeClass('on hover').addClass('off');

            if (!this.options.disabled) {
                this._addClassToStars('on', $('input', this.element).val());
            }
        },

        refreshLayout: function () {
            var starRating = this;
            var stars = $(".star", starRating.element);
            var clearRating = $(".clearRating", starRating.element);
            var img, url;

            // Fix size of star elements
            function applyStarSize(width, height) {
                var splittedWidth = width / starRating.options.numParts;
                stars.width(splittedWidth);
                stars.height(height);
                $.each(stars, function () {
                    var offsetPart = parseFloat($(this).attr('value')) - (1 / starRating.options.numParts).toFixed(3);
                    offsetPart = Math.floor(offsetPart) - offsetPart;
                    $('a', this).width(width).height(height).css('margin-left', parseInt(offsetPart * width, 10).toString() + 'px');
                });
            }

            stars.attr('style', '');
            $('a', stars).attr('style', '');
            var starWidth = stars.width() || $('img.defaultStarImage', starRating.element).width();
            var starHeight = stars.height() || $('img.defaultStarImage', starRating.element).height();
            if (starWidth && starHeight) {
                applyStarSize(starWidth, starHeight);
            } else {
                img = $('img.defaultStarImage', starRating.element);
                if (img.length === 0) {
                    url = $('a', stars).css('background-image').replace("url(", "").replace(")", "").replace(/['"]/gi, '');
                    img = $('<img />');
                    img.hide()
                       .addClass('defaultStarImage')
                       .attr('src', url)
                       .imagesLoaded(function () { applyStarSize($(img).width(), $(img).height()); })
                       .appendTo(this.element);
                }
            }

            // Fix size of "Clear Rating" element
            clearRating.attr('style', '');
            var clearWidth = clearRating.width() || $('img.defaultClearImage').width();
            var clearHeight = clearRating.height() || $('img.defaultClearImage').height();
            if (clearWidth && clearHeight) {
                clearRating.width(clearWidth).height(clearHeight);
            } else {
                img = $('img.defaultClearImage', starRating.element);
                if (img.length === 0) {
                    url = clearRating.css('background-image').replace("url(", "").replace(")", "").replace(/['"]/gi, '');
                    img = $('<img />');
                    img.hide()
                       .addClass('defaultClearImage')
                       .attr('src', url)
                       .imagesLoaded(function () { clearRating.width($(img).width()).height($(img).height()); })
                       .appendTo(this.element);
                }
            }
        },

        clearRating: function () {
            $('input', this.element).val('');
            this.refresh();
        },

        getRating: function () {
            var value = parseFloat($('input', this.element).val());
            return isNaN(value) ? null : value;
        },

        setRating: function (value) {
            $('input', this.element).val(value);
            this.refresh();
        },

        destroy: function () {
            $.Widget.prototype.destroy.call(this);
        }

    });
}(jQuery));